/*----------  INCLUDE HEADER FILE  ----------*/

#include "CanDoMJC.h"

/*----------  SUPPORT FUNCTIONS  ----------*/

void MJPlot(struct Window *w, WORD maxdwell, LONG scale,
            struct ComplexRange *cr, struct complex *jc, UBYTE type)
{
   struct RastPort *rp;
   struct complex c, z, zloop;
   struct IntuiMessage *message;
   WORD xstart=0, ystart=0, x, y, xend, yend;
   WORD count;
   DOUBLE rstep, istep, zrtemp;
   ULONG oldIDCMPFlags;

   rp = w->RPort;
   oldIDCMPFlags = w->IDCMPFlags;
   ModifyIDCMP(w, MOUSEBUTTONS);

   xend = 8*(rp->BitMap->BytesPerRow)-1;
   yend = (rp->BitMap->Rows)-1;
   rstep = (cr->rmax - cr->rmin)*scale/xend;
   istep = (cr->imax - cr->imin)*scale/yend;

   SetRast(rp,0);
   if (type == MANDELBROT) {
      for (c.i = cr->imax, y=ystart ; y<=yend ; c.i-=istep, y+=scale) {
	 if(message = (struct IntuiMessage *)GetMsg(w->UserPort)) {
	    ReplyMsg((struct Message *)message);
	    break;
	 } /* if */
	 for (c.r = cr->rmin, x=xstart ; x<=xend ; c.r+=rstep, x+=scale) {
	    zloop.r = zloop.i = 0.;
	    count = 0;

	    do {
	       zrtemp = zloop.r*zloop.r - zloop.i*zloop.i + c.r;
	       zloop.i = 2.*zloop.r*zloop.i + c.i;
	       zloop.r = zrtemp;
	       if((zloop.r*zloop.r + zloop.i*zloop.i) > 4.) break;
	       ++count;
	    } while (count < maxdwell);

	    SetAPen(rp, count);
	    if (scale == 1)
	       WritePixel(rp, x, y);
	    else
	       RectFill(rp, x, y, x+scale-1, y+scale-1);
	 } /* for */
      } /* for */
   } /* if */

   else if (type == JULIA) {
      for (z.i = cr->imax, y=ystart ; y<=yend ; z.i-=istep, y+=scale) {
         if(message = (struct IntuiMessage *)GetMsg(w->UserPort)) {
            ReplyMsg((struct Message *)message);
            break;
         } /* if */
         for (z.r = cr->rmin, x=xstart ; x<=xend ; z.r+=rstep, x+=scale) {
            zloop.r = z.r;
            zloop.i = z.i;
            count = 0;

            do {
               if((zloop.r*zloop.r + zloop.i*zloop.i) > 4.) break;
               ++count;
               zrtemp = zloop.r*zloop.r - zloop.i*zloop.i + jc->r;
               zloop.i = 2.*zloop.r*zloop.i + jc->i;
               zloop.r = zrtemp;
            } while (count < maxdwell);

	    SetAPen(rp, count);
	    if (scale == 1)
	       WritePixel(rp, x, y);
	    else
	       RectFill(rp, x, y, x+scale-1, y+scale-1);
	 } /* for */
      } /* for */
   } /* else if */

   ModifyIDCMP(w, oldIDCMPFlags);

} /* MJPlot */

void SetComplexRange(struct ComplexRange *r, DOUBLE rmin,
                     DOUBLE rmax, DOUBLE imin, DOUBLE imax)
{
   r->rmin = rmin;
   r->rmax = rmax;
   r->imin = imin;
   r->imax = imax;
} /* SetComplexRange */


/*---------------  MAIN PROGRAM  ---------------*/

LONG main (int argc, char *argv[])
{
   /* LOCAL VARIABLES */
   
   struct Window *CanDoWin;
   struct ComplexRange mrange;
   struct ComplexRange jrange; 
   struct complex jc;

   char **dummy=NULL;
   char MandOrJulia;

   WORD maxdwell;
   WORD resolution;

   DOUBLE rmin, rmax, imin, imax;

   /* OPEN LIBRARIES */
   
   if (!OpenLibraries()) {
      CloseLibraries();
      return 1L;
   } /* if */

   /* EXECUTE PROGRAM IF RIGHT NUMBER OF ARGUMENTS */
   
   if (argc >= 9) {
      CanDoWin=(struct Window *)(strtoul(argv[1],dummy,10));
      maxdwell=(WORD)(strtoul(argv[2],dummy,10));
      resolution=(WORD)(strtoul(argv[3],dummy,10));
      rmin=strtod(argv[4],dummy);
      rmax=strtod(argv[5],dummy);
      imin=strtod(argv[6],dummy);
      imax=strtod(argv[7],dummy);
      MandOrJulia=*(argv[8]);
      
      if (MandOrJulia == 'M') {
        SetComplexRange(&mrange, rmin, rmax, imin, imax);
        MJPlot(CanDoWin, maxdwell, resolution, &mrange, NULL, MANDELBROT);
      } /* if */

      else if (MandOrJulia == 'J') {
        jc.r=strtod(argv[9],dummy);
        jc.i=strtod(argv[10],dummy);
        SetComplexRange(&jrange, rmin, rmax, imin, imax);
        MJPlot(CanDoWin, maxdwell, resolution, &jrange, &jc, JULIA);
      } /* else if */
   } /* if argc >= 2 */

   CloseLibraries();

} /* main */
